@extends('admin.layout.template')
@section('title', 'Project Details')
@section('content')
<style>
    .offcanvas {
        width: 420px !important;
    }
</style>
<div class="page-content">
    <div class="container-xxl">

        {{-- ================= PROJECT HEADER ================= --}}
        <div class="card mb-4 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">

                    {{-- LEFT SIDE --}}
                    <div>
                        <h3 class="mb-2">
                            {{ $project->project_name }}
                            <span class="badge bg-info ms-2">
                                {{ $project->project_number }}
                            </span>
                        </h3>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <p class="mb-1">
                                    <strong>Customer :</strong>
                                    {{ $project->customer_name }}
                                </p>
                                <p class="mb-1">
                                    <strong>Phone :</strong>
                                    {{ $project->customer_phone }}
                                </p>
                                <p class="mb-1">
                                    <strong>Address :</strong>
                                    {{ $project->address }}
                                </p>
                            </div>

                            <div class="col-md-6">
                                <p class="mb-1">
                                    <strong>Project Type :</strong>
                                    {{ $project->project_type ?? '-' }}
                                </p>

                                <p class="mb-1">
                                    <strong>Expected Completion :</strong>
                                    {{ $project->expected_completion_date 
                                ? \Carbon\Carbon::parse($project->expected_completion_date)->format('d M Y') 
                                : '-' }}
                                </p>

                                <p class="mb-1">
                                    <strong>Status :</strong>
                                    <span class="badge 
                                @if($project->status == 'completed') bg-success
                                @elseif($project->status == 'pending') bg-warning
                                @else bg-secondary
                                @endif">
                                        {{ ucfirst($project->status) }}
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>

                    {{-- RIGHT SIDE --}}
                    <div class="text-end">

                        <p class="mb-1">
                            <strong>Employee :</strong>
                            {{ $project->employee_name ?? '-' }}
                        </p>

                        <p class="mb-3">
                            <strong>Contact :</strong>
                            {{ $project->employee_contact ?? '-' }}
                        </p>

                        {{-- PDF Buttons --}}
                        <div class="d-flex justify-content-end align-items-center gap-2 flex-wrap">

                            {{-- Upload / Update --}}
                            <button class="btn btn-dark btn-sm px-3"
                                data-bs-toggle="modal"
                                data-bs-target="#quotationModal">
                                <i class="bi bi-upload"></i>
                                {{ $project->quotation_pdf ? 'Update Quotation' : 'Upload Quotation' }}
                            </button>

                            {{-- View Quotation (if exists) --}}
                            @if($project->quotation_pdf)
                            <a href="{{ asset($project->quotation_pdf) }}"
                                target="_blank"
                                class="btn btn-success btn-sm px-3">
                                <i class="bi bi-eye"></i> View
                            </a>
                            @endif

                            <button class="btn btn-info btn-sm px-3"
                                data-bs-toggle="modal"
                                data-bs-target="#totalamountnModal">
                                <i class="bi bi-upload"></i>
                                {{ $project->total_amount==0 ? 'Add Total Amount' : 'Update Total Amount' }}
                            </button>

                            {{-- More Actions Dropdown --}}
                            <div class="dropdown">
                                <button class="btn btn-outline-secondary btn-sm dropdown-toggle"
                                    data-bs-toggle="dropdown">
                                    More PDFs
                                </button>

                                <ul class="dropdown-menu dropdown-menu-end shadow">
                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/measurement/'.$project->id) }}"
                                            target="_blank">
                                            Measurement PDF
                                        </a>
                                    </li>

                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/invoice/'.$project->id) }}"
                                            target="_blank">
                                            Invoice PDF
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/quotation/'.$project->id) }}"
                                            target="_blank">
                                            Client Quotation
                                        </a>
                                    </li>
                                </ul>
                            </div>

                        </div>

                    </div>

                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>Subtotal</h6>
                        <h4 class="text-primary">
                            ₹ {{ number_format($project->subtotal, 2) }}
                        </h4>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>GST (18%)</h6>
                        <h4 class="text-warning">
                            ₹ {{ number_format($project->tax, 2) }}
                        </h4>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>Grand Total</h6>
                        <h4 class="text-success">
                            ₹ {{ number_format($project->grand_total, 2) }}
                        </h4>
                    </div>
                </div>
            </div>
        </div>

        {{-- ================= PROJECT SUMMARY ================= --}}
        <div class="row mb-2">
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h5>Total Areas</h5>
                        <h3>{{ $project->areas->count() }}</h3>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h5>Total Items</h5>
                        <h3>
                            {{ $project->areas->sum(fn($area) => $area->items->count()) }}
                        </h3>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h5>Total Amount Entered</h5>
                        <h6> {{ $project->total_amount }}</h6>
                    </div>
                </div>
            </div>
        </div>



        {{-- ================= AREAS LOOP ================= --}}
        @foreach($project->areas as $area)

        <div class="card mb-4">
            <div class="card-header bg-light">
                <h5 class="mb-0">
                    Area: {{ $area->name }}
                    @if($area->room)
                    <span class="text-muted">
                        (Room: {{ $area->room->name }})
                    </span>
                    @endif
                </h5>
            </div>

            <div class="card-body">

                @if($area->items->count() > 0)

                <div class="table-responsive">
                    <table class="table table-bordered align-middle table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="4%">#</th>
                                <th width="8%">Image</th>
                                <th width="12%">Product</th>
                                <th width="8%">Type</th>
                                <th width="8%">Unit</th>
                                <th width="8%">Qty</th>
                                <th width="12%">Size</th>
                                <th width="12%">Room</th>
                                <th width="10%">Item</th>
                                <th width="12%">Catalog</th>
                                <th width="10%">Serial</th>
                                <th>Description</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach($area->items as $index => $item)

                            @php
                            $unit = 'Nos';
                            $qty = 1;

                            // ===============================
                            // NON CUSTOM
                            // ===============================
                            if($item->is_custom == 0){

                            $qty = (float) ($item->quantity ?? 1);

                            if($item->category == 'curtain'){
                            $unit = 'Pcs';
                            }
                            elseif($item->category == 'wallpaper'){
                            $unit = 'Rolls';
                            }

                            }
                            // ===============================
                            // CUSTOM CURTAIN
                            // ===============================
                            elseif($item->category == 'curtain' && $item->curtain && $item->measurement){

                            $fw = (float) $item->curtain->fabric_width;
                            $ww = (float) $item->measurement->width;
                            $wh = (float) $item->measurement->height;

                            if($fw > 0){
                            $panels = ceil($ww / $fw);
                            $qty = $panels * $wh;
                            }

                            $unit = 'Meter';
                            }
                            // ===============================
                            // CUSTOM WALLPAPER
                            // ===============================
                            elseif($item->category == 'wallpaper' && $item->wallpaper){

                            $rw = (float) $item->wallpaper->roll_width;
                            $rl = (float) $item->wallpaper->roll_length;
                            $ww = (float) $item->wallpaper->wall_width;
                            $wh = (float) $item->wallpaper->wall_height;
                            $rep = (float) ($item->wallpaper->design_repeat ?? 0);

                            if($rw > 0 && $rl > 0){
                            $cuttings = ceil($ww / $rw);
                            $totalLength = $cuttings * ($wh + $rep);
                            $qty = ceil($totalLength / $rl);
                            }

                            $unit = 'Rolls';
                            }
                            @endphp

                            <tr>

                                {{-- SL --}}
                                <td>{{ $index + 1 }}</td>

                                {{-- IMAGE --}}
                                <td>
                                    @if($item->is_custom == 0 && $item->variant?->primaryImage?->image_path)
                                    <img src="{{ asset($item->variant->primaryImage->image_path) }}" width="60">
                                    @else
                                    <span class="text-muted">Custom</span>
                                    @endif
                                </td>

                                {{-- PRODUCT --}}
                                <td>
                                    {{ $item->product->name ?? 'Custom Item' }}
                                </td>

                                {{-- TYPE (is_custom badge) --}}
                                <td>
                                    @if($item->is_custom == 1)
                                    <span class="badge bg-warning text-dark">Custom</span>
                                    @else
                                    <span class="badge bg-success">Standard</span>
                                    @endif
                                </td>

                                {{-- UNIT --}}
                                <td>{{ $unit }}</td>

                                {{-- QTY --}}
                                <td>{{ $qty > 0 ? number_format($qty,2) : '-' }}</td>

                                {{-- SIZE --}}
                                <td>
                                    @if($item->measurement)
                                    {{ $item->measurement->width ?? '-' }}
                                    x
                                    {{ $item->measurement->height ?? '-' }}
                                    {{ $item->measurement->unit ?? '' }}
                                    @else
                                    -
                                    @endif
                                </td>

                                {{-- ROOM --}}
                                <td>{{ $area->area_name ?? $area->name ?? '-' }}</td>

                                {{-- CATEGORY --}}
                                <td>{{ ucfirst($item->category ?? '-') }}</td>

                                {{-- CATALOG --}}
                                <td>
                                    {{
            $item->curtain->catalogue ??
            $item->wallpaper->catalogue ??
            '-'
        }}
                                </td>

                                {{-- SERIAL --}}
                                <td>
                                    {{
            $item->curtain->serial_no ??
            $item->wallpaper->serial_no ??
            '-'
        }}
                                </td>

                                {{-- DESCRIPTION --}}
                                <td>{{ $item->notes ?? '-' }}
<button 
    class="btn btn-sm btn-warning editItemBtn"
    data-bs-toggle="offcanvas"
    data-bs-target="#quotationItemsForm"

    data-project_item_id="{{ $item->id }}"
    data-area_id="{{ $area->id }}"
    data-category="{{ $item->category }}"
     data-subcategory="{{ $item->category }}"
    data-quantity="{{ $item->quantity }}"
    data-note="{{ $item->notes }}"
    data-width="{{ $item->measurement->width ?? '' }}"
    data-height="{{ $item->measurement->height ?? '' }}"
    data-unit="{{ $item->measurement->unit ?? '' }}"
    data-model="{{ $item->curtain->model ?? '' }}"
    data-motorized="{{ $item->curtain->motorized ?? 0 }}"
>
    Edit
</button>

                                </td>

                            </tr>

                            @endforeach

                        </tbody>
                    </table>
                </div>


                @else
                <p class="text-muted">No items found in this area.</p>
                @endif

            </div>
        </div>

        @endforeach


        <a href="{{ route('projects.index') }}" class="btn btn-secondary mt-3">Back to Projects</a>

    </div>
</div>

<!-- Quotation Upload Modal -->
<div class="modal fade" id="quotationModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">

            <form action="{{ route('projects.upload.quotation', $project->id) }}"
                method="POST"
                enctype="multipart/form-data">

                @csrf

                <div class="modal-header">
                    <h5 class="modal-title">
                        {{ $project->quotation_pdf ? 'Update' : 'Upload' }} Quotation PDF
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="mb-3">
                        <label class="form-label">Select PDF File</label>
                        <input type="file"
                            name="quotation_pdf"
                            class="form-control"
                            accept="application/pdf"
                            required>
                        <small class="text-muted">
                            Max size: 4MB
                        </small>
                    </div>

                    @if($project->quotation_pdf)
                    <p>
                        Current File:
                        <a href="{{ asset($project->quotation_pdf) }}"
                            target="_blank">
                            View PDF
                        </a>
                    </p>
                    @endif

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">
                        {{ $project->quotation_pdf ? 'Update' : 'Upload' }}
                    </button>
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>

<!-- update total amount Modal -->
<div class="modal fade" id="totalamountnModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">

            <form action="{{ route('projects-uptate-total', $project->id) }}"
                method="POST"
                enctype="multipart/form-data">

                @csrf

                <div class="modal-header">
                    <h5 class="modal-title">
                        {{ $project->quotation_pdf ? 'Update' : 'Upload' }} Quotation PDF
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" name="project_id" value="{{$project->id}}">
                    <div class="mb-3">
                        <label class="form-label">Enter total</label>
                        <input type="number" step="0.1"
                            name="total_amount"
                            class="form-control"
                            required>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">
                        {{ $project->total_amount==0 ? 'Add' : 'Update' }}
                    </button>
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>




<!-- Quotation Item Right Sidebar Modal -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="quotationItemsForm" aria-labelledby="quotationItemsFormLabel">
    <div class="offcanvas-header">
        <h5 id="quotationItemsFormLabel">Add / Edit Item</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body">
        <form id="quotationItemForm">
            @csrf
            <input type="hidden" name="project_id" value="{{ $project->id }}">
            <input type="hidden" name="area_id" id="area_id">
            <input type="hidden" name="project_item_id" id="project_item_id">

            {{-- Category --}}
            <div class="mb-3">
                <label for="category" class="form-label">Category</label>
                <select name="category" id="category" class="form-select" required>
                    <option value="">Select Category</option>
                    @foreach(App\Models\Category::all() as $cat)
                    <option value="{{ $cat->id }}">{{ ucfirst($cat->name) }}</option>
                    @endforeach
                </select>
            </div>

            {{-- Subcategory (dynamic) --}}
            <div class="mb-3 d-none" id="subcategoryDiv">
                <label for="subcategory" class="form-label">Subcategory</label>
                <select name="subcategory" id="subcategory" class="form-select"></select>
            </div>

            {{-- Catalogue / Product --}}
            <div class="mb-3 d-none" id="catalogueDiv">
                <label for="product_id" class="form-label">Product / Catalogue</label>
                <select name="product_id" id="product_id" class="form-select"></select>
            </div>

            {{-- Variant / SKU --}}
            <div class="mb-3 d-none" id="variantDiv">
                <label for="variant_id" class="form-label">Variant / SKU</label>
                <select name="variant_id" id="variant_id" class="form-select"></select>
            </div>

            {{-- Quantity --}}
           <div class="mb-3" id="quantityDiv">
    <label for="quantity" class="form-label">Quantity</label>
    <input type="number" name="quantity" id="quantity"
           class="form-control" value="1" min="1">
</div>

            {{-- Measurement / Details (dynamic container) --}}
            <div id="dynamicFields"></div>

            {{-- Notes --}}
            <div class="mb-3">
                <label for="note" class="form-label">Note</label>
                <textarea name="note" id="note" class="form-control" rows="2"></textarea>
            </div>

            <button type="submit" class="btn btn-primary w-100">Save Item</button>
        </form>
    </div>
</div>

<script>
    // Edit Button Click
$(document).on('click', '.editItemBtn', function() {

    let btn = $(this);

    // Reset form first
    $('#quotationItemForm')[0].reset();
    $('#dynamicFields').html('');

    // Fill hidden fields
    $('#project_item_id').val(btn.data('project_item_id'));
    $('#area_id').val(btn.data('area_id'));

    // Set basic fields
    $('#note').val(btn.data('note'));
    $('#quantity').val(btn.data('quantity'));

    // Set category
    let categoryName = btn.data('category');
    $("#category option").each(function() {
        if ($(this).text().toLowerCase() === categoryName.toLowerCase()) {
            $(this).prop("selected", true).change();
        }
    });

    // Wait for dynamic fields to load
    setTimeout(function() {

        if (categoryName === 'curtain') {

            $('select[name="model"]').val(btn.data('model'));
            $('select[name="details[motorized]"]').val(btn.data('motorized'));
            $('input[name="measurement[width]"]').val(btn.data('width'));
            $('input[name="measurement[height]"]').val(btn.data('height'));
            $('select[name="measurement[unit]"]').val(btn.data('unit'));

            // Hide quantity for curtain
            $('#quantityDiv').hide();
        }

        $('#quotationItemForm button[type="submit"]').text('Update Item');

    }, 600);
});

    $(document).ready(function() {

        // On category change
        $('#category').on('change', function() {
            let categoryId = $(this).val();
            if (!categoryId) return;

            // Show dynamic fields container
            $('#dynamicFields').html('');

            // Fetch subcategories and catalogues
            $.get('/config/category/' + categoryId, function(res) {
                if (res.subcategories.length > 0) {
                    $('#subcategory').html('<option value="">Select Subcategory</option>');
                    res.subcategories.forEach(sc => {
                        $('#subcategory').append(`<option value="${sc.id}">${sc.name}</option>`);
                    });
                    $('#subcategoryDiv').removeClass('d-none');
                } else {
                    $('#subcategoryDiv').addClass('d-none');
                }

     if(res.models.length > 0) {
                let modelDropdown = $('select[name="model"]');
                res.models.forEach(model => {
                    modelDropdown.append(`<option value="${model}">${model}</option>`);
                });
            }

                if (res.catalogues.length > 0) {
                    $('#product_id').html('<option value="">Select Catalogue</option>');
                    res.catalogues.forEach(c => {
                        $('#product_id').append(`<option value="${c.product_id}">${c.catalogue}</option>`);
                    });
                    $('#catalogueDiv').removeClass('d-none');
                } else {
                    $('#catalogueDiv').addClass('d-none');
                }
            });
        });

        // On subcategory change
        $('#subcategory').on('change', function() {
            let subId = $(this).val();
            if (!subId) return;

            $.get('/config/subcategory/' + subId, function(res) {
                if (res.catalogues.length > 0) {
                    $('#product_id').html('<option value="">Select Catalogue</option>');
                    res.catalogues.forEach(c => {
                        $('#product_id').append(`<option value="${c.product_id}">${c.catalogue}</option>`);
                    });
                    $('#catalogueDiv').removeClass('d-none');
                }
            });
        });

        // On product change
        $('#product_id').on('change', function() {
            let productId = $(this).val();
            if (!productId) return;

            $.get('/config/catalogue-skus/' + productId, function(res) {
                if (res.skus.length > 0) {
                    $('#variant_id').html('<option value="">Select Variant</option>');
                    res.skus.forEach(v => {
                        let dim = v.dimensions ? ` (${v.dimensions})` : '';
                        $('#variant_id').append(`<option value="${v.variant_id}">${v.sku} - ₹${v.offer_price}${dim}</option>`);
                    });
                    $('#variantDiv').removeClass('d-none');
                }

                // Add dynamic category-based fields
                let category = $('#category option:selected').text().toLowerCase();
                let html = '';
                if (category === 'curtain') {
                    html = `
                <div class="mb-3">
                <label class="form-label">Select Model</label>
                <select name="model" class="form-select" required>
                    <option value="">Select Model</option>
                </select>
            </div>
            
                    <div class="mb-3">
                        <label class="form-label">Motorized</label>
                        <select name="details[motorized]" class="form-select">
                            <option value="0">No</option>
                            <option value="1">Yes</option>
                        </select>
                    </div>
                     <div class="mb-3">
                        <label class="form-label">Motor Control</label>
                        <select name="details[motor_control]" class="form-select">
                            <option value="0">Left</option>
                            <option value="1">Right</option>
                        </select>
                    </div>
                     <div class="mb-3">
                        <label class="form-label">Select Unit</label>
                        <select name="measurement[unit]" class="form-select">
                            <option value="">Select Unit</option>
                        </select>
                    </div>
                    <p class="mb-3">Measurement</p>
                 <div class="d-flex">
                    <div class="mb-3">
                        <label class="form-label">Width </label>
                        <input type="number" name="measurement[width]" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Height</label>
                        <input type="number" name="measurement[height]" class="form-control" required>
                    </div>
                    </div>
                `;
                } else if (category === 'mattress') {
                    html = `
                    <div class="mb-3">
                        <label class="form-label">Type</label>
                        <select name="details[type]" class="form-select">
                            <option value="king">King</option>
                            <option value="queen">Queen</option>
                            <option value="single">Single</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Thickness</label>
                        <input type="number" name="details[thickness]" class="form-control" required>
                    </div>
                `;
                }
                $('#dynamicFields').html(html);
            });
        });

        // Submit form
        $('#quotationItemForm').on('submit', function(e) {
            e.preventDefault();
            let formData = new FormData(this);

            $.ajax({
                url: '/api/project/areas/items',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(res) {
                    alert('Item saved successfully!');
                    location.reload(); // refresh list
                },
                error: function(err) {
                    console.log(err);
                    alert('Something went wrong!');
                }
            });
        });

    });
</script>
@endsection